<?php
require_once '../core/bootstrap.php';

$league = new League();
$leagues = $league->getAll();

$pageTitle = 'All Leagues';
include_once 'includes/header.php';
?>

<h1>All Leagues</h1>
<div class="list-container">
    <?php if (empty($leagues)): ?>
        <p>No leagues have been created yet.</p>
    <?php else: ?>
        <?php foreach ($leagues as $l): ?>
            <a href="league_table.php?id=<?php echo $l->id; ?>" class="list-item">
                <img src="/smart_football/uploads/club_logos/<?php echo htmlspecialchars($l->logo ?? 'default.png'); ?>" alt="<?php echo htmlspecialchars($l->name); ?> Logo" class="item-logo">
                <span><?php echo htmlspecialchars($l->name); ?></span>
            </a>
        <?php endforeach; ?>
    <?php endif; ?>
</div>

<?php include_once 'includes/footer.php'; ?>