<?php
// A simple config loader to get the URL_ROOT for links.
if (file_exists('core/config.php')) {
    require_once 'core/config.php';
} else {
    // Fallback if config is not yet created during setup
    $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
    $host = $_SERVER['HTTP_HOST'];
    $root_dir = dirname($_SERVER['SCRIPT_NAME']);
    if ($root_dir === '/' || $root_dir === '\\') $root_dir = '';
    define('URL_ROOT', $protocol . '://' . $host . $root_dir);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Smart Football - System Documentation</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <style>
        :root {
            --primary-color: #2c3e50;
            --secondary-color: #3498db;
            --accent-color: #2ecc71;
            --text-dark: #333;
            --text-light: #f8f9fa;
            --bg-light: #ffffff;
            --bg-grey: #f8f9fa;
        }
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            margin: 0;
            line-height: 1.7;
            color: var(--text-dark);
            background-color: var(--bg-grey);
        }
        .container {
            max-width: 900px;
            margin: 0 auto;
            padding: 0 20px;
        }
        /* Header */
        .main-header {
            background: var(--primary-color);
            padding: 1rem 0;
            color: var(--text-light);
        }
        .main-header .container {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .logo { font-size: 1.5rem; font-weight: 800; color: var(--text-light); text-decoration: none; }
        .print-button {
            display: inline-block;
            padding: 8px 20px;
            background: var(--secondary-color);
            color: #fff;
            border-radius: 5px;
            text-decoration: none;
            font-weight: bold;
            transition: background 0.3s;
            border: none;
            cursor: pointer;
        }
        .print-button:hover { background: #2980b9; }

        /* Main Content */
        .doc-wrapper {
            background: var(--bg-light);
            margin: 2rem auto;
            padding: 40px 50px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            border-radius: 8px;
        }

        h1, h2, h3, h4 {
            color: var(--primary-color);
            line-height: 1.3;
            margin-top: 1.5em;
            margin-bottom: 0.8em;
            border-bottom: 1px solid #eee;
            padding-bottom: 0.4em;
        }
        h1 { font-size: 2.8rem; text-align: center; border-bottom: 2px solid var(--primary-color); }
        h2 { font-size: 2rem; }
        h3 { font-size: 1.5rem; border-bottom-style: dashed; }
        h4 { font-size: 1.2rem; border-bottom: none; font-weight: 700; }

        p { margin-bottom: 1rem; }
        ul { padding-left: 20px; }
        li { margin-bottom: 0.5rem; }

        /* Table of Contents */
        #toc {
            background: var(--bg-grey);
            padding: 20px;
            border-radius: 8px;
            border-left: 5px solid var(--secondary-color);
            margin-bottom: 2rem;
        }
        #toc h2 { margin-top: 0; border-bottom: none; }
        #toc ul { list-style: none; padding: 0; }
        #toc ul li a { text-decoration: none; color: var(--secondary-color); font-weight: 600; }
        #toc ul li a:hover { text-decoration: underline; }
        #toc > ul > li { margin-bottom: 0.8rem; }
        #toc ul ul { padding-left: 20px; margin-top: 0.5rem; }
        #toc ul ul li { margin-bottom: 0.3rem; font-size: 0.9rem; }

        /* Role Cards */
        .role-card {
            background: var(--bg-light);
            padding: 25px;
            border-radius: 8px;
            border: 1px solid #eee;
            margin-bottom: 1.5rem;
        }
        .role-card h4 { display: flex; align-items: center; gap: 10px; font-size: 1.2rem; color: var(--primary-color); margin-top: 0; }
        .role-card h4 i { color: var(--accent-color); }
        .role-card ul { list-style: none; padding: 0; margin: 0; }
        .role-card li { padding-left: 1.5em; position: relative; margin-bottom: 0.5rem; font-size: 0.95rem; }
        .role-card li::before {
            content: '\f00c'; /* Font Awesome check icon */
            font-family: 'Font Awesome 6 Free';
            font-weight: 900;
            position: absolute;
            left: 0;
            color: var(--accent-color);
        }

        /* Footer */
        .main-footer {
            text-align: center;
            padding: 2rem 0;
            color: #777;
            font-size: 0.9rem;
        }

        @media print {
            body {
                background: #fff;
                color: #000;
            }
            .main-header, .main-footer {
                display: none;
            }
            .doc-wrapper {
                box-shadow: none;
                margin: 0;
                padding: 0;
                border-radius: 0;
            }
            h1, h2, h3 {
                page-break-after: avoid;
            }
            a {
                color: inherit;
                text-decoration: none;
            }
            .role-card {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>

    <header class="main-header">
        <div class="container">
            <a href="#" class="logo">Smart Football</a>
            <button class="print-button" onclick="window.print()"><i class="fas fa-print"></i> Print / Save as PDF</button>
        </div>
    </header>

    <div class="container">
        <div class="doc-wrapper">
            <h1>System Documentation</h1>
            <p style="text-align: center; font-style: italic; color: #666;">The all-in-one digital platform to manage, engage, and grow your football ecosystem.</p>

            <nav id="toc">
                <h2>Table of Contents</h2>
                <ul>
                    <li><a href="#overview">1. System Overview</a></li>
                    <li>
                        <a href="#roles">2. User Roles & Engagement</a>
                        <ul>
                            <li><a href="#role-fa">2.1 Football Association / Admin</a></li>
                            <li><a href="#role-club">2.2 Club Manager</a></li>
                            <li><a href="#role-team">2.3 Team Manager</a></li>
                            <li><a href="#role-player">2.4 Player</a></li>
                            <li><a href="#role-fan">2.5 Fan & Supporter</a></li>
                            <li><a href="#role-sponsor">2.6 Sponsor & Advertiser</a></li>
                        </ul>
                    </li>
                    <li>
                        <a href="#features">3. Core Features</a>
                        <ul>
                            <li><a href="#feature-league">3.1 League & Fixture Management</a></li>
                            <li><a href="#feature-scoring">3.2 Live Scoring & Match Reports</a></li>
                            <li><a href="#feature-finance">3.3 Integrated Financial Control</a></li>
                            <li><a href="#feature-roster">3.4 Team & Roster Management</a></li>
                            <li><a href="#feature-fantasy">3.5 Engaging Fantasy League</a></li>
                            <li><a href="#feature-ads">3.6 Sponsorship & Advertising</a></li>
                        </ul>
                    </li>
                    <li><a href="#expansion">4. Potential for Expansion</a></li>
                    <li><a href="#adoption">5. Conclusion: Why Adopt Smart Football?</a></li>
                </ul>
            </nav>

            <section id="overview">
                <h2>1. System Overview</h2>
                <p>
                    Smart Football is a comprehensive, cloud-based platform designed to streamline every aspect of football league operations. It serves as a central hub that connects administrators, clubs, players, and fans in a single, intuitive digital ecosystem.
                </p>
                <p>
                    The system moves beyond simple score tracking by integrating financial management, automated disciplinary actions, detailed player statistics, and powerful engagement tools like a built-in fantasy league. By digitizing and automating manual processes, Smart Football reduces administrative overhead, increases transparency, and unlocks new revenue streams for the entire football community.
                </p>
            </section>

            <section id="roles">
                <h2>2. User Roles & Engagement</h2>
                <p>The platform is designed to empower every stakeholder in the football community with tools tailored to their specific needs.</p>

                <div id="role-fa" class="role-card">
                    <h4><i class="fas fa-sitemap"></i> 2.1 Football Association / Admin</h4>
                    <p>Administrators have complete oversight of the entire league structure, ensuring rules are enforced and operations run smoothly.</p>
                    <ul>
                        <li>Gain complete oversight with a centralized data dashboard.</li>
                        <li>Automate disciplinary actions (fines, suspensions) based on match events.</li>
                        <li>Ensure financial transparency with detailed transaction logs and commission reports.</li>
                        <li>Generate new revenue through system-wide commissions on fees and memberships.</li>
                        <li>Manage user roles, permissions, and system-wide settings.</li>
                        <li>Approve club registrations and team rosters.</li>
                    </ul>
                </div>

                <div id="role-club" class="role-card">
                    <h4><i class="fas fa-user-tie"></i> 2.2 Club Manager</h4>
                    <p>Club Managers are responsible for the overall health and administration of their club, including finances and staffing.</p>
                    <ul>
                        <li>Manage the club's central wallet and transfer funds to individual team wallets.</li>
                        <li>Pay club-level registration fees and player/staff fines.</li>
                        <li>Hire and manage staff, including assigning Team Managers to specific teams.</li>
                        <li>Create and manage fan membership packages to drive revenue.</li>
                        <li>Monitor all club activities, finances, and team performance from a central dashboard.</li>
                    </ul>
                </div>

                <div id="role-team" class="role-card">
                    <h4><i class="fas fa-clipboard-list"></i> 2.3 Team Manager</h4>
                    <p>Team Managers handle the day-to-day operations of their specific squad.</p>
                    <ul>
                        <li>Effortlessly submit official match lineups before kick-off.</li>
                        <li>Manage squad rosters, add/remove players during transfer windows, and edit player details.</li>
                        <li>Track player injuries and training session attendance.</li>
                        <li>Handle team-specific finances, including paying referee fees from the team wallet.</li>
                    </ul>
                </div>

                <div id="role-player" class="role-card">
                    <h4><i class="fas fa-running"></i> 2.4 Player</h4>
                    <p>Players get a professional platform to track their career and performance.</p>
                    <ul>
                        <li>Build a professional profile with detailed career statistics (goals, assists, appearances).</li>
                        <li>View personal performance metrics and AI-generated attribute ratings.</li>
                        <li>Receive notifications for match selections, fines, and suspensions.</li>
                        <li>Track injury history and expected return dates.</li>
                    </ul>
                </div>

                <div id="role-fan" class="role-card">
                    <h4><i class="fas fa-flag"></i> 2.5 Fan & Supporter</h4>
                    <p>Fans are brought closer to the action with real-time data and interactive features.</p>
                    <ul>
                        <li>Follow live match scores, events, and statistics in real-time.</li>
                        <li>Compete against friends and other fans in an interactive fantasy league.</li>
                        <li>Support their favorite club by purchasing official digital memberships.</li>
                        <li>Stay updated with league news, announcements, and fixture changes.</li>
                    </ul>
                </div>

                <div id="role-sponsor" class="role-card">
                    <h4><i class="fas fa-handshake"></i> 2.6 Sponsor & Advertiser</h4>
                    <p>A dedicated portal allows businesses and individuals to reach a highly engaged football audience.</p>
                    <ul>
                        <li>Purchase branding sponsorships for leagues or specific matches.</li>
                        <li>Run targeted Pay-Per-Click (PPC) or Pay-Per-View (PPV) ad campaigns.</li>
                        <li>Set total and daily budgets to control ad spend.</li>
                        <li>Track campaign performance with built-in analytics on views and clicks.</li>
                        <li>Pause, resume, and edit active campaigns.</li>
                    </ul>
                </div>
            </section>

            <section id="features">
                <h2>3. Core Features</h2>
                
                <h3 id="feature-league">3.1 League & Fixture Management</h3>
                <p>Administrators can easily set up and manage multiple leagues and seasons. The system includes a fixture generation tool to automatically create a balanced schedule for all teams in a league, which can then be manually adjusted as needed.</p>
                
                <h3 id="feature-scoring">3.2 Live Scoring & Match Reports</h3>
                <p>Assigned Match Commissioners can use a dedicated interface to log match events (goals, cards, substitutions, etc.) in real-time. This data instantly updates the public-facing fixture pages, providing a live experience for fans. After the match, this data is compiled into official match reports.</p>
                
                <h3 id="feature-finance">3.3 Integrated Financial Control</h3>
                <p>The system features a robust wallet system for the board, clubs, and individual teams. It automates financial transactions, such as deducting referee fees from team wallets, issuing fines for yellow/red cards, and distributing commissions to the league and system administrators from various revenue streams.</p>
                
                <h3 id="feature-roster">3.4 Team & Roster Management</h3>
                <p>Club Managers can create teams, and Team Managers can build their rosters by adding registered players. During open registration or transfer windows, managers can add or release players. Submitted rosters are sent to league administrators for approval, locking the squad until it is approved.</p>
                
                <h3 id="feature-fantasy">3.5 Engaging Fantasy League</h3>
                <p>A fully-featured fantasy football game is integrated into the platform. Fans can create teams, select a squad within a budget, make transfers, and compete in public and private leagues. Player points are automatically calculated and awarded based on their real-world match performances.</p>
                
                <h3 id="feature-ads">3.6 Sponsorship & Advertising</h3>
                <p>The platform provides a self-service portal for sponsors and advertisers. Users can purchase high-visibility branding packages (e.g., league sponsor) or run performance-based advertising campaigns (PPC/PPV) with custom budgets, creatives, and target links.</p>
            </section>

            <section id="expansion">
                <h2>4. Potential for Expansion</h2>
                <p>The flexible architecture of Smart Football is built to grow and accommodate future needs. Potential expansion modules include:</p>
                <ul>
                    <li><strong>Native Mobile Apps:</strong> Dedicated iOS and Android applications for an even richer, more accessible user experience.</li>
                    <li><strong>Advanced Analytics:</strong> AI-driven insights, predictive analysis for match outcomes, and in-depth team performance reports for scouts and managers.</li>
                    <li><strong>Integrated Ticketing:</strong> A complete solution for selling match tickets online, managing attendance, and scanning at the gate.</li>
                    <li><strong>E-commerce & Club Shops:</strong> Allow clubs to set up online shops to sell official merchandise directly to their fanbase, creating another revenue stream.</li>
                </ul>
            </section>

            <section id="adoption">
                <h2>5. Conclusion: Why Adopt Smart Football?</h2>
                <p>
                    Embracing the digital transformation of football is no longer an option—it's a necessity for growth and efficiency. By centralizing operations, Smart Football empowers associations to increase efficiency, reduce administrative overhead, and unlock powerful new ways to engage their community.
                </p>
                <p>
                    The platform provides the tools to not only manage a league but to grow it, ensuring it is transparent, profitable, and future-proof. It creates a virtuous cycle where better management leads to greater fan engagement, which in turn attracts more sponsors, providing the financial fuel for further development of the sport at a grassroots level.
                </p>
            </section>

        </div>
    </div>

    <footer class="main-footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Smart Football. All Rights Reserved.</p>
        </div>
    </footer>

</body>
</html>