<?php
// core/bootstrap.php

// 1. Check for Config
if (!file_exists(__DIR__ . '/config.php')) {
    // Check if setup.php exists in the parent directory (root)
    $setup_path = dirname(__DIR__) . '/setup.php';
    if (file_exists($setup_path)) {
        // Determine the relative URL to setup.php
        // We assume the app structure is standard: /app/index.php -> /setup.php
        $protocol = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? "https" : "http";
        $host = $_SERVER['HTTP_HOST'];
        
        // Get the directory of the current script (e.g., /smart_football/app)
        $current_dir = dirname($_SERVER['SCRIPT_NAME']);
        // Go up one level to find root (e.g., /smart_football)
        $root_dir = dirname($current_dir);
        if ($root_dir === '/' || $root_dir === '\\') $root_dir = '';
        
        header('Location: ' . $protocol . '://' . $host . $root_dir . '/setup.php');
        exit;
    } else {
        die('Configuration file (core/config.php) is missing and setup.php was not found.');
    }
}

// 2. Load Config & Autoloader
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

spl_autoload_register(function ($className) {
    require_once __DIR__ . '/' . $className . '.php';
});

// 3. Start Session
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}