<?php

class Autoloader {
    private $dirs = [];

    public function __construct(array $dirs = []) {
        // Add the default 'core' directory
        $this->dirs[] = APP_ROOT . '/core';

        // Add any additional directories provided
        foreach ($dirs as $dir) {
            $this->dirs[] = APP_ROOT . '/' . ltrim($dir, '/');
        }
    }

    public function __invoke($className) {
        foreach ($this->dirs as $dir) {
            $file = $dir . '/' . $className . '.php';
            if (file_exists($file)) {
                require_once $file;
                return;
            }
        }
    }
}

// The registration itself is now handled in bootstrap.php
?>