<?php
$pageTitle = 'Add Injury Record';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$teamModel = new Team();
$playerModel = new Player();

// Get the manager's team to find the players
$team = $teamModel->getTeamByManagerId($manager_id);

$team_players = [];
if ($team) {
    $team_players = $playerModel->getPlayersByTeamId($team->id);
} else {
    // If no team, they can't add an injury.
    header('Location: my_team.php');
    exit();
}

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Add Injury Record</h1>
    </div>

    <div class="form-container">
        <form action="add_injury_process.php" method="POST" class="auth-form" style="max-width: 600px; margin: auto;">
            <div class="form-group">
                <label for="player_id">Player</label>
                <select name="player_id" id="player_id" required>
                    <option value="">-- Select a Player --</option>
                    <?php foreach ($team_players as $player): ?>
                        <option value="<?php echo $player->id; ?>"><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="injury_description">Injury Description</label>
                <input type="text" id="injury_description" name="injury_description" placeholder="e.g., Hamstring Strain" required>
            </div>
            <div class="form-group">
                <label for="start_date">Date of Injury</label>
                <input type="date" id="start_date" name="start_date" required>
            </div>
            <div class="form-group">
                <label for="expected_return_date">Expected Return Date (Optional)</label>
                <input type="date" id="expected_return_date" name="expected_return_date">
            </div>

            <button type="submit">Add Injury Record</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>