<?php

class Season {
    private $db;

    public function __construct(){
        $this->db = new Database;
    }

    // Get all seasons
    public function getAll(){
        $this->db->query('SELECT * FROM seasons ORDER BY name DESC');
        return $this->db->resultSet();
    }

    // Create a new season
    public function create($name){
        $this->db->query('INSERT INTO seasons (name) VALUES (:name)');
        $this->db->bind(':name', $name);
        if($this->db->execute()){
            return $this->db->lastInsertId();
        } else {
            return false;
        }
    }

    // Delete a season
    public function delete($id){
        $this->db->query('DELETE FROM seasons WHERE id = :id');
        $this->db->bind(':id', $id);
        return $this->db->execute();
    }
}
?>