<?php
class Announcement extends Model {
    public function getAll() {
        $this->db->query("SELECT a.*, u.first_name, u.last_name FROM announcements a JOIN users u ON a.created_by = u.id ORDER BY a.created_at DESC");
        return $this->db->resultSet();
    }

    public function getActive() {
        $this->db->query("SELECT * FROM announcements WHERE is_active = 1 ORDER BY created_at DESC");
        return $this->db->resultSet();
    }

    public function create($data) {
        $this->db->query("INSERT INTO announcements (title, content, type, created_by) VALUES (:title, :content, :type, :created_by)");
        $this->db->bind(':title', $data['title']);
        $this->db->bind(':content', $data['content']);
        $this->db->bind(':type', $data['type']);
        $this->db->bind(':created_by', $data['created_by']);
        return $this->db->execute();
    }

    public function delete($id) {
        $this->db->query("DELETE FROM announcements WHERE id = :id");
        $this->db->bind(':id', $id);
        return $this->db->execute();
    }
    
    public function toggleStatus($id) {
        $this->db->query("UPDATE announcements SET is_active = NOT is_active WHERE id = :id");
        $this->db->bind(':id', $id);
        return $this->db->execute();
    }
}
