<?php
$pageTitle = 'Training Attendance';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$teamModel = new Team();
$trainingModel = new Training();

// Get the manager's team
$team = $teamModel->getTeamByManagerId($manager_id);

$sessions = [];
if ($team) {
    $sessions = $trainingModel->getSessionsByTeamId($team->id);
}

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Training Attendance</h1>
        <a href="/smart_football/app/record_attendance.php" class="btn">Record New Attendance</a>
    </div>

    <?php if ($team): ?>
        <div class="dashboard-section">
            <h2 class="dashboard-title">Past Sessions</h2>
            <?php if (!empty($sessions)): ?>
                <div class="fixture-list">
                    <?php foreach ($sessions as $session): ?>
                        <a href="/smart_football/app/training_session_detail.php?id=<?php echo $session->id; ?>" class="fixture-item">
                            <div class="team home-team">Session: <?php echo date('D, d M Y', strtotime($session->session_date)); ?></div>
                            <div class="score-box"><?php echo $session->present_count; ?> / <?php echo $session->total_count; ?></div>
                            <div class="team away-team">Present</div>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <p class="no-data-msg">No training sessions have been recorded yet.</p>
            <?php endif; ?>
        </div>
    <?php else: ?>
        <p class="no-data-msg">You are not currently assigned as a manager to any team.</p>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>