<?php
$pageTitle = 'Team Hub';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'player') {
    header('Location: login.php');
    exit();
}
$player_id = $_SESSION['user_id'];

// --- Instantiate Models ---
$playerModel = new Player();
$fixtureModel = new Fixture();

// --- Fetch Data ---
// Get the player's full details, which includes their team info
$player = $playerModel->getPlayerDetailsById($player_id);

if (!$player || !$player->team_id) {
    // This case handles players who might not be assigned to a team yet.
    echo "<div class='page-content'><p class='no-data-msg'>You are not currently assigned to a team.</p></div>";
    include 'includes/footer.php';
    exit();
}

$team_id = $player->team_id;

// Fetch all data related to the team
$team_players = $playerModel->getPlayersByTeamId($team_id);
$next_fixture = $fixtureModel->getUpcomingFixturesForTeam($team_id)[0] ?? null;
$recent_results = $fixtureModel->getRecentResultsForTeam($team_id, 5);
$injured_players = $playerModel->getInjuredPlayersByTeamId($team_id);
$suspended_players = $playerModel->getSuspendedPlayersByTeamId($team_id);

?>

<div class="page-content">
    <div class="matches-header">
        <div class="team-header-info">
            <img src="<?php echo htmlspecialchars($player->club_logo); ?>" alt="<?php echo htmlspecialchars($player->club_name); ?>" class="team-logo-lg">
            <div>
                <h1><?php echo htmlspecialchars($player->team_name); ?> Hub</h1>
                <p><?php echo htmlspecialchars($player->club_name); ?></p>
            </div>
        </div>
    </div>

    <div class="team-hub-grid">
        <!-- Left Column -->
        <div class="hub-main-column">
            <!-- Next Match -->
            <div class="dashboard-section">
                <h2 class="dashboard-title">Next Match</h2>
                <?php if ($next_fixture): ?>
                    <div class="fixture-list">
                        <a href="fixture.php?id=<?php echo $next_fixture->id; ?>" class="fixture-item">
                            <div class="team home-team"><?php echo htmlspecialchars($next_fixture->home_team_name); ?></div>
                            <div class="score-box time-box">
                                <span class="time"><?php echo date('H:i', strtotime($next_fixture->match_datetime)); ?></span>
                                <span class="date"><?php echo date('d M Y', strtotime($next_fixture->match_datetime)); ?></span>
                            </div>
                            <div class="team away-team"><?php echo htmlspecialchars($next_fixture->away_team_name); ?></div>
                        </a>
                    </div>
                <?php else: ?>
                    <p class="no-data-msg">No upcoming matches scheduled.</p>
                <?php endif; ?>
            </div>

            <!-- Recent Results -->
            <div class="dashboard-section">
                <h2 class="dashboard-title">Recent Results</h2>
                <?php if (!empty($recent_results)): ?>
                    <div class="fixture-list mini-list">
                        <?php foreach ($recent_results as $result): ?>
                            <a href="fixture.php?id=<?php echo $result->id; ?>" class="fixture-item">
                                <div class="team home-team"><?php echo htmlspecialchars($result->home_team_name); ?></div>
                                <div class="score-box"><?php echo $result->home_team_score; ?> - <?php echo $result->away_team_score; ?></div>
                                <div class="team away-team"><?php echo htmlspecialchars($result->away_team_name); ?></div>
                            </a>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="no-data-msg">No recent results available.</p>
                <?php endif; ?>
            </div>
        </div>

        <!-- Right Column -->
        <div class="hub-sidebar-column">
            <!-- Team Roster -->
            <div class="dashboard-section">
                <h2 class="dashboard-title">Team Roster</h2>
                <div class="table-wrapper">
                    <table class="styled-table">
                        <thead><tr><th>#</th><th>Name</th><th>Position</th></tr></thead>
                        <tbody>
                            <?php foreach ($team_players as $p): ?>
                                <tr class="<?php echo ($p->id == $player_id) ? 'highlighted-row' : ''; ?>">
                                    <td><?php echo htmlspecialchars($p->squad_number); ?></td>
                                    <td><a href="player.php?id=<?php echo $p->id; ?>"><?php echo htmlspecialchars($p->first_name . ' ' . $p->last_name); ?></a></td>
                                    <td><?php echo htmlspecialchars($p->position); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Unavailable Players -->
            <?php if (!empty($injured_players) || !empty($suspended_players)): ?>
            <div class="dashboard-section">
                <h2 class="dashboard-title">Unavailable Players</h2>
                <ul class="unavailable-list">
                    <?php foreach ($injured_players as $p): ?>
                        <li><i class="fa-solid fa-plus" style="color: #e74c3c;"></i> <?php echo htmlspecialchars($p->first_name . ' ' . $p->last_name); ?> (Injured)</li>
                    <?php endforeach; ?>
                    <?php foreach ($suspended_players as $p): ?>
                        <li><i class="fa-solid fa-ban" style="color: #e74c3c;"></i> <?php echo htmlspecialchars($p->first_name . ' ' . $p->last_name); ?> (Suspended)</li>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.team-header-info { display: flex; align-items: center; gap: 20px; }
.team-logo-lg { width: 60px; height: 60px; }
.team-hub-grid { display: grid; grid-template-columns: 2fr 1fr; gap: 2rem; }
.fixture-list.mini-list .fixture-item { font-size: 0.9rem; padding: 10px; }
.unavailable-list { list-style: none; padding: 0; }
.unavailable-list li { padding: 5px 0; }
@media (max-width: 900px) { .team-hub-grid { grid-template-columns: 1fr; } }
</style>

<?php include 'includes/footer.php'; ?>