<?php
$pageTitle = 'Select Fixture for Lineup';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

// --- Instantiate Models ---
$teamModel = new Team();
$fixtureModel = new Fixture();
$lineupModel = new Lineup();

// --- Fetch Data ---
$team = $teamModel->getTeamByManagerId($manager_id);
if (!$team) {
    header('Location: my_team.php?error=no_team');
    exit();
}

$upcoming_fixtures = $fixtureModel->getUpcomingFixturesForTeam($team->id);

?>

<div class="page-content">
    <div class="dashboard-hero">
        <div class="hero-content">
            <h1>Select Fixture</h1>
            <p>Choose an upcoming match to submit or edit your team lineup.</p>
        </div>
    </div>

    <div class="dashboard-section">
        <?php if (!empty($upcoming_fixtures)): ?>
            <div class="fixture-list">
                <?php foreach ($upcoming_fixtures as $fixture):
                    $lineup_submitted = $lineupModel->hasLineupBeenSubmitted($fixture->id, $team->id);
                    $status_class = $lineup_submitted ? 'submitted' : 'pending';
                    $status_text = $lineup_submitted ? 'Lineup Submitted' : 'Submit Lineup';
                    $status_icon = $lineup_submitted ? '<i class="fa-solid fa-check-circle"></i>' : '<i class="fa-solid fa-pen-to-square"></i>';
                ?>
                    <a href="/smart_football/app/submit_lineup.php?fixture_id=<?php echo $fixture->id; ?>" class="fixture-item lineup-fixture-item">
                        <div class="fixture-main">
                            <div class="team home-team">
                                <span class="team-name"><?php echo htmlspecialchars($fixture->home_team_name); ?></span>
                                <img src="<?php echo htmlspecialchars($fixture->home_team_logo); ?>" alt="" class="team-logo">
                            </div>
                            <div class="score-box time-box">
                                <span class="time"><?php echo date('H:i', strtotime($fixture->match_datetime)); ?></span>
                                <span class="date"><?php echo date('d M', strtotime($fixture->match_datetime)); ?></span>
                            </div>
                            <div class="team away-team">
                                <img src="<?php echo htmlspecialchars($fixture->away_team_logo); ?>" alt="" class="team-logo">
                                <span class="team-name"><?php echo htmlspecialchars($fixture->away_team_name); ?></span>
                            </div>
                        </div>
                        <div class="lineup-status-badge <?php echo $status_class; ?>">
                            <?php echo $status_icon . ' ' . $status_text; ?>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <p class="no-data-msg">There are no upcoming fixtures scheduled for your team.</p>
        <?php endif; ?>
    </div>
</div>

<style>
.dashboard-hero {
    background: linear-gradient(135deg, var(--primary-color, #3498db) 0%, #2c3e50 100%);
    color: white;
    padding: 3rem 2rem;
    border-radius: 12px;
    margin-bottom: 2rem;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    text-align: center;
}

.hero-content h1 {
    margin: 0 0 10px 0;
    font-size: 2rem;
}

.hero-content p {
    margin: 0;
    opacity: 0.9;
    font-size: 1.1rem;
}

.fixture-item {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
    text-decoration: none;
    color: inherit;
    border: 1px solid #eee;
    transition: transform 0.2s;
    display: flex;
}

.lineup-fixture-item {
    display: flex;
    flex-direction: column;
    align-items: stretch;
    gap: 15px;
    padding: 20px;
}

.fixture-main {
    display: flex;
    justify-content: space-between;
    align-items: center;
    width: 100%;
}

.lineup-status-badge {
    margin-top: 5px;
    text-align: center;
    padding: 8px;
    border-radius: 6px;
    font-weight: 600;
    font-size: 0.9rem;
    width: 100%;
    transition: background-color 0.2s;
}

.lineup-status-badge.pending {
    background-color: #f0f4f8;
    color: var(--primary-color, #3498db);
    border: 1px solid #d1d9e6;
}

.lineup-status-badge.submitted {
    background-color: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.fixture-item:hover .lineup-status-badge.pending {
    background-color: var(--primary-color, #3498db);
    color: white;
    border-color: var(--primary-color, #3498db);
}

.fixture-main .team {
    flex: 1;
    display: flex;
    align-items: center;
    gap: 12px;
}

.fixture-main .team.home-team {
    justify-content: flex-end;
}

.fixture-main .team-logo {
    width: 36px;
    height: 36px;
    object-fit: contain;
}

.fixture-main .team-name {
    font-weight: 600;
    font-size: 1rem;
}

.fixture-main .score-box {
    margin: 0 15px;
    text-align: center;
}

.fixture-main .time {
    font-size: 1.2rem;
    font-weight: 700;
}

.fixture-main .date {
    font-size: 0.75rem;
    color: #7f8c8d;
    text-transform: uppercase;
}
</style>

<?php include 'includes/footer.php'; ?>