<?php
$pageTitle = 'Search Results';
include 'includes/header.php';

$query = $_GET['q'] ?? '';
$playerModel = new Player();
$teamModel = new Team();

$players = [];
$teams = [];

if (!empty($query)) {
    $players = $playerModel->searchPlayers($query);
    $teams = $teamModel->searchTeams($query);
}
?>

<div class="page-content">
    <div class="matches-header">
        <h1>Search Results for "<?php echo htmlspecialchars($query); ?>"</h1>
    </div>

    <?php if (empty($players) && empty($teams)): ?>
        <div class="dashboard-section">
            <p class="no-data-msg">No results found matching your query.</p>
        </div>
    <?php endif; ?>

    <?php if (!empty($teams)): ?>
        <div class="dashboard-section">
            <h2 class="dashboard-title">Teams</h2>
            <div class="search-results-grid">
                <?php foreach ($teams as $team): ?>
                    <a href="#" class="search-card team-card"> <!-- Link to team page if available -->
                        <img src="<?php echo htmlspecialchars($team->club_logo); ?>" alt="<?php echo htmlspecialchars($team->name); ?>">
                        <div class="search-info">
                            <h4><?php echo htmlspecialchars($team->name); ?></h4>
                            <span><?php echo htmlspecialchars($team->club_name); ?></span>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>

    <?php if (!empty($players)): ?>
        <div class="dashboard-section">
            <h2 class="dashboard-title">Players</h2>
            <div class="search-results-grid">
                <?php foreach ($players as $player): ?>
                    <a href="player.php?id=<?php echo $player->id; ?>" class="search-card player-card">
                        <img src="<?php echo htmlspecialchars($player->profile_picture ?? '/smart_football/public/assets/images/default_avatar.png'); ?>" alt="<?php echo htmlspecialchars($player->first_name); ?>">
                        <div class="search-info">
                            <h4><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></h4>
                            <span><?php echo htmlspecialchars($player->position); ?></span>
                            <?php if ($player->club_name): ?>
                                <small><?php echo htmlspecialchars($player->club_name); ?></small>
                            <?php endif; ?>
                        </div>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<style>
.search-results-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
    gap: 1rem;
    padding: 1rem;
}
.search-card {
    display: flex;
    align-items: center;
    gap: 15px;
    background: #fff;
    padding: 15px;
    border-radius: 8px;
    border: 1px solid #eee;
    text-decoration: none;
    color: inherit;
    transition: transform 0.2s;
}
.search-card:hover { transform: translateY(-2px); border-color: var(--primary-color); }
.search-card img { width: 50px; height: 50px; object-fit: cover; border-radius: 50%; }
.search-info h4 { margin: 0 0 5px 0; font-size: 1rem; }
.search-info span { font-size: 0.85rem; color: #666; display: block; }
.search-info small { font-size: 0.75rem; color: #999; }
</style>

<?php include 'includes/footer.php'; ?>