<?php
$pageTitle = 'My Stats';
include 'includes/header.php';
 
// Protect this page and check for the correct role.
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'player') {
    // Redirect to login or a generic access denied page.
    header('Location: login.php');
    exit();
}
$player_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$statModel = new Stat();
$userModel = new User();

$player = $userModel->findById($player_id);
$player_stats = $statModel->getStatsForPlayer($player_id);

?>

<div class="page-content">
    <div class="matches-header">
        <h1>My Season Stats</h1>
    </div>

    <?php if ($player && $player_stats): ?>
        <div class="stats-card-grid">
            <div class="stat-card">
                <div class="stat-value"><?php echo $player_stats->appearances; ?></div>
                <div class="stat-label">Appearances</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo $player_stats->goals; ?></div>
                <div class="stat-label">Goals</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo $player_stats->assists; ?></div>
                <div class="stat-label">Assists</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo $player_stats->yellow_cards; ?></div>
                <div class="stat-label">Yellow Cards</div>
            </div>
            <div class="stat-card">
                <div class="stat-value"><?php echo $player_stats->red_cards; ?></div>
                <div class="stat-label">Red Cards</div>
            </div>
        </div>
    <?php else: ?>
        <p class="no-data-msg">Could not retrieve player stats at this time.</p>
    <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>