<?php
$pageTitle = 'All Notifications';
include 'includes/header.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}
$user_id = $_SESSION['user_id'];

$notificationModel = new Notification();
$notifications = $notificationModel->getAllByUser($user_id); // Assuming this method exists to get all notifications

?>

<div class="page-content">
    <div class="matches-header">
        <h1>All Notifications</h1>
    </div>
    <div class="dashboard-section">
        <div class="notification-list-full">
            <?php if (empty($notifications)): ?>
                <p class="no-data-msg">You have no notifications.</p>
            <?php else: ?>
                <?php foreach ($notifications as $n): ?>
                    <div class="notification-item <?php echo $n->is_read ? '' : 'unread'; ?>">
                        <div class="notification-icon"><i class="fa-solid fa-futbol"></i></div>
                        <div class="notification-content">
                            <p><?php echo strip_tags($n->message, '<a>'); ?></p>
                            <small><?php echo date('d M Y, H:i', strtotime($n->created_at)); ?></small>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</div>

<style>
.notification-list-full {
    background: #fff;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}
</style>

<?php include 'includes/footer.php'; ?>