<?php
require_once '../core/bootstrap.php';

// If user is already logged in, redirect them to the homepage.
if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

$pageTitle = 'Login';
include 'includes/header.php';
?>

<div class="page-content auth-page">
    <div class="auth-wrapper">
        <div class="auth-container">
            <div class="auth-header">
                <img src="<?php echo htmlspecialchars($appLogo); ?>" alt="<?php echo htmlspecialchars($appName); ?> Logo" class="auth-logo">
                <h1>Welcome Back</h1>
                <p>Please enter your credentials to login.</p>
            </div>

            <?php
            // Display success message for registration
            if (isset($_GET['registered']) && $_GET['registered'] === 'success') {
                echo '<div class="status-message success">Registration successful! Please login.</div>';
            }

            // Display any error messages from failed login attempts
            if (isset($_GET['error'])) {
                $errorMsg = '';
                if ($_GET['error'] == 'invalid_credentials') {
                    $errorMsg = 'The email or password you entered is incorrect.';
                } elseif ($_GET['error'] == 'missing_fields') {
                    $errorMsg = 'Please fill in all fields.';
                }
                if ($errorMsg) {
                    echo '<div class="error-message"><i class="fa-solid fa-circle-exclamation"></i> ' . $errorMsg . '</div>';
                }
            }
            ?>

            <form action="login_process.php" method="POST" class="auth-form">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <div class="input-group">
                        <span class="input-icon"><i class="fa-solid fa-envelope"></i></span>
                        <input type="email" id="email" name="email" placeholder="you@example.com" required>
                    </div>
                </div>
                <div class="form-group">
                    <label for="password">Password</label>
                    <div class="input-group">
                        <span class="input-icon"><i class="fa-solid fa-lock"></i></span>
                        <input type="password" id="password" name="password" placeholder="••••••••" required>
                        <button type="button" class="toggle-password" onclick="togglePasswordVisibility()" title="Show/Hide Password">
                            <i class="fa-solid fa-eye"></i>
                        </button>
                    </div>
                </div>
                <button type="submit" class="btn-login">Login <i class="fa-solid fa-arrow-right"></i></button>
            </form>
            <div class="auth-footer">
                <a href="forgot_password.php">Forgot Password?</a>
                <span>Don't have an account? <a href="register.php">Sign Up</a></span>
            </div>
        </div>
    </div>
</div>

<script>
function togglePasswordVisibility() {
    const passwordInput = document.getElementById('password');
    const toggleIcon = document.querySelector('.toggle-password i');
    if (passwordInput.type === 'password') {
        passwordInput.type = 'text';
        toggleIcon.classList.remove('fa-eye');
        toggleIcon.classList.add('fa-eye-slash');
    } else {
        passwordInput.type = 'password';
        toggleIcon.classList.remove('fa-eye-slash');
        toggleIcon.classList.add('fa-eye');
    }
}
</script>

<?php include 'includes/footer.php'; ?>