<?php
require_once '../core/bootstrap.php';

if (isset($_SESSION['user_id'])) {
    header('Location: index.php');
    exit();
}

$pageTitle = 'Forgot Password';
include 'includes/header.php';
?>

<div class="page-content auth-page">
    <div class="auth-wrapper">
        <div class="auth-container" style="max-width: 450px;">
            <div class="auth-header">
                <h1>Reset Password</h1>
                <p>Enter your email to receive a reset link.</p>
            </div>

            <?php if (isset($_GET['status']) && $_GET['status'] === 'sent'): ?>
                <div class="status-message success">If an account exists for that email, we have sent a password reset link.</div>
            <?php elseif (isset($_GET['error'])): ?>
                <div class="error-message"><?php echo htmlspecialchars($_GET['error']); ?></div>
            <?php endif; ?>

            <form action="forgot_password_process.php" method="POST" class="auth-form">
                <div class="form-group">
                    <label for="email">Email Address</label>
                    <input type="email" id="email" name="email" placeholder="you@example.com" required>
                </div>
                <button type="submit" class="btn-login">Send Reset Link</button>
            </form>
            
            <div class="auth-footer">
                <a href="login.php">Back to Login</a>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>