<?php
$pageTitle = 'Fine History';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

// --- Instantiate Models ---
$teamModel = new Team();
$fineModel = new Fine();
$settingModel = new Setting();
$paymentModel = new Payment();

// Get the manager's team
$team = $teamModel->getTeamByManagerId($manager_id);

$all_fines = [];

// --- Get Currency Symbol from Settings ---
$settings = $settingModel->getAll();
$currency_code = $settings['system_currency'] ?? 'USD';
$currency_symbol = '$';
if ($currency_code === 'ZMW') {
    $currency_symbol = 'K';
} elseif ($currency_code === 'EUR') {
    $currency_symbol = '€';
} // Add other currencies as needed

if ($team && isset($team->club_id)) {
    $all_fines = $fineModel->getAllFinesForTeam($team->club_id);
}

// Fetch Payment Transactions
$transactions = $paymentModel->getByUserId($manager_id);

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Team Fine History</h1>
        <a href="my_team.php" class="btn btn-secondary"><i class="fa-solid fa-arrow-left"></i> Back to Dashboard</a>
    </div>

    <div class="dashboard-section">
        <h2 class="dashboard-title">Payment Transactions</h2>
        <div class="table-wrapper">
            <?php if (!empty($transactions)): ?>
                <table class="styled-table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Reference</th>
                            <th>Amount</th>
                            <th>Method</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $txn): ?>
                            <tr>
                                <td><?php echo date('d M Y, H:i', strtotime($txn->created_at)); ?></td>
                                <td><?php echo htmlspecialchars($txn->transaction_ref); ?></td>
                                <td><?php echo $currency_symbol . number_format($txn->amount, 2); ?></td>
                                <td><?php echo ucfirst($txn->payment_gateway); ?></td>
                                <td><a href="receipt.php?ref=<?php echo $txn->transaction_ref; ?>&context=team_manager" class="btn-sm">View Receipt</a></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="no-data-msg">No payment transactions found.</p>
            <?php endif; ?>
        </div>
    </div>

    <div class="dashboard-section">
        <div class="table-wrapper">
            <?php if (!empty($all_fines)): ?>
                <table class="styled-table">
                    <thead>
                        <tr>
                            <th>Entity</th>
                            <th>Reason</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Date Issued</th>
                            <th>Date Paid</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($all_fines as $fine): ?>
                            <tr>
                                <td>
                                    <?php
                                    if ($fine->entity_type === 'player') {
                                        echo htmlspecialchars($fine->first_name . ' ' . $fine->last_name);
                                    } elseif ($fine->entity_type === 'club') {
                                        echo htmlspecialchars($fine->club_name_fined);
                                    }
                                    ?>
                                </td>
                                <td><?php echo htmlspecialchars($fine->reason); ?></td>
                                <td><?php echo $currency_symbol; ?><?php echo number_format($fine->amount, 2); ?></td>
                                <td>
                                    <span class="status-badge status-<?php echo strtolower($fine->status); ?>">
                                        <?php echo ucfirst($fine->status); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d M Y', strtotime($fine->issued_date)); ?></td>
                                <td>
                                    <?php
                                    if ($fine->paid_date) {
                                        echo date('d M Y', strtotime($fine->paid_date));
                                    } else {
                                        echo 'N/A';
                                    }
                                    ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="no-data-msg">No fines have been recorded for your team.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>