<?php
$pageTitle = 'Edit Player';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

$player_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$player_id) {
    header('Location: my_team.php?error=invalid_player');
    exit();
}

// --- Instantiate Models ---
$playerModel = new Player();
$teamModel = new Team();

// --- Security Check & Data Fetching ---
$team = $teamModel->getTeamByManagerId($manager_id);
$player = $playerModel->getPlayerDetailsById($player_id);

// Ensure player exists and belongs to the manager's team
if (!$player || !$team || $player->team_id != $team->id) {
    header('Location: my_team.php?error=access_denied');
    exit();
}

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Edit Player: <?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></h1>
        <a href="my_team.php" class="btn-sm">Back to Team</a>
    </div>

    <!-- Display any success or error messages -->
    <?php if (isset($_GET['status'])): ?>
        <div class="status-message <?php echo $_GET['status'] === 'success' ? 'success' : 'error'; ?>">
            <?php
            if ($_GET['status'] === 'success') {
                echo 'Player details updated successfully!';
            } elseif (isset($_GET['error'])) {
                echo 'Error: ' . htmlspecialchars($_GET['error']);
            }
            ?>
        </div>
    <?php endif; ?>

    <div class="form-container" style="max-width: 600px; margin: auto;">
        <form action="edit_player_process.php" method="POST" class="auth-form">
            <input type="hidden" name="player_id" value="<?php echo $player->id; ?>">

            <div class="form-group">
                <label for="squad_number">Squad Number</label>
                <input type="number" id="squad_number" name="squad_number" value="<?php echo htmlspecialchars($player->squad_number); ?>" min="1" max="99">
            </div>
            <div class="form-group">
                <label for="position">Position</label>
                <select name="position" id="position">
                    <option value="Goalkeeper" <?php echo ($player->position === 'Goalkeeper') ? 'selected' : ''; ?>>Goalkeeper</option>
                    <option value="Defender" <?php echo ($player->position === 'Defender') ? 'selected' : ''; ?>>Defender</option>
                    <option value="Midfielder" <?php echo ($player->position === 'Midfielder') ? 'selected' : ''; ?>>Midfielder</option>
                    <option value="Forward" <?php echo ($player->position === 'Forward') ? 'selected' : ''; ?>>Forward</option>
                </select>
            </div>
            <div class="form-group">
                <label for="height_cm">Height (cm)</label>
                <input type="number" id="height_cm" name="height_cm" value="<?php echo htmlspecialchars($player->height_cm); ?>">
            </div>
            <div class="form-group">
                <label for="weight_kg">Weight (kg)</label>
                <input type="number" id="weight_kg" name="weight_kg" value="<?php echo htmlspecialchars($player->weight_kg); ?>">
            </div>
            <div class="form-group">
                <label for="date_of_birth">Date of Birth</label>
                <input type="date" id="date_of_birth" name="date_of_birth" value="<?php echo htmlspecialchars($player->date_of_birth); ?>">
            </div>
            <div class="form-group">
                <label for="nationality">Nationality</label>
                <input type="text" id="nationality" name="nationality" value="<?php echo htmlspecialchars($player->nationality); ?>">
            </div>
            <div class="form-group">
                <label for="preferred_foot">Preferred Foot</label>
                <select name="preferred_foot" id="preferred_foot">
                    <option value="Right" <?php echo ($player->preferred_foot === 'Right') ? 'selected' : ''; ?>>Right</option>
                    <option value="Left" <?php echo ($player->preferred_foot === 'Left') ? 'selected' : ''; ?>>Left</option>
                    <option value="Both" <?php echo ($player->preferred_foot === 'Both') ? 'selected' : ''; ?>>Both</option>
                </select>
            </div>

            <button type="submit">Update Player</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>