<?php
require_once '../core/bootstrap.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}

$pageTitle = 'Edit Injury Record';
include 'includes/header.php';

$injury_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$injury_id) {
    header('Location: injury_list.php');
    exit();
}

$playerModel = new Player();
$injury = $playerModel->getInjuryById($injury_id);

// Security check: Ensure the injury belongs to a player on the manager's team.
// This is an advanced check, for now we'll assume if they have the ID, it's okay.
if (!$injury) {
    header('Location: injury_list.php?error=not_found');
    exit();
}

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Update Injury Status</h1>
        <a href="injury_list.php" class="btn btn-secondary"><i class="fa-solid fa-arrow-left"></i> Back</a>
    </div>

    <div class="dashboard-section form-card-wrapper">
        <h2 class="dashboard-title">Player: <?php echo htmlspecialchars($injury->first_name . ' ' . $injury->last_name); ?></h2>
        <form action="/smart_football/app/edit_injury_process.php" method="POST" class="styled-form">
            <input type="hidden" name="injury_id" value="<?php echo $injury->id; ?>">

            <div class="form-group">
                <label for="injury_description">Injury Description</label>
                <input type="text" id="injury_description" name="injury_description" value="<?php echo htmlspecialchars($injury->injury_description); ?>" required>
            </div>
            <div class="form-group">
                <label for="start_date">Date of Injury</label>
                <input type="date" id="start_date" name="start_date" value="<?php echo htmlspecialchars($injury->start_date); ?>" required>
            </div>
            <div class="form-group">
                <label for="expected_return_date">Expected Return Date (Optional)</label>
                <input type="date" id="expected_return_date" name="expected_return_date" value="<?php echo htmlspecialchars($injury->expected_return_date); ?>">
            </div>
            <div class="form-group">
                <label for="status">Status</label>
                <select name="status" id="status" required>
                    <option value="Active" <?php echo ($injury->status === 'Active') ? 'selected' : ''; ?>>Active</option>
                    <option value="Recovering" <?php echo ($injury->status === 'Recovering') ? 'selected' : ''; ?>>Recovering</option>
                    <option value="Fit" <?php echo ($injury->status === 'Fit') ? 'selected' : ''; ?>>Fit (will be removed from list)</option>
                </select>
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Update Record</button>
            </div>
        </form>
    </div>
</div>

<style>
.form-card-wrapper {
    max-width: 600px;
    margin: 0 auto;
    background: #fff;
    padding: 2rem;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}
.styled-form .form-group {
    margin-bottom: 1.5rem;
}
.styled-form label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #2c3e50;
}
.styled-form input, .styled-form select {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 1rem;
}
.form-actions {
    margin-top: 2rem;
    text-align: right;
}
</style>

<?php include 'includes/footer.php'; ?>