<?php
$pageTitle = 'Edit Attendance';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

$session_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
if (!$session_id) {
    header('Location: /smart_football/app/training_attendance.php?error=invalid_id');
    exit();
}

// --- Instantiate Models and Fetch Data ---
$trainingModel = new Training();
$teamModel = new Team();
$playerModel = new Player();

// Security check and data fetching
$team = $teamModel->getTeamByManagerId($manager_id);
if (!$team || !$trainingModel->checkSessionBelongsToManager($session_id, $team->id)) {
    header('Location: /smart_football/app/training_attendance.php?error=access_denied');
    exit();
}

$session = $trainingModel->getSessionDetailsById($session_id);
$team_players = $playerModel->getPlayersByTeamId($team->id);

if (!$session) {
    header('Location: /smart_football/app/training_attendance.php?error=not_found');
    exit();
}

// Create a lookup map for existing attendance for easier form population
$attendance_map = [];
foreach ($session->attendees as $attendee) {
    $attendance_map[$attendee->player_id] = $attendee->status;
}
?>

<div class="page-content">
    <div class="matches-header">
        <h1>Edit Training Attendance</h1>
    </div>

    <div class="form-container">
        <form action="/smart_football/app/edit_attendance_process.php" method="POST" class="auth-form" style="max-width: 700px; margin: auto;">
            <input type="hidden" name="session_id" value="<?php echo $session->id; ?>">
            <div class="form-group">
                <label for="session_date">Session Date</label>
                <input type="date" id="session_date" name="session_date" value="<?php echo htmlspecialchars($session->session_date); ?>" required>
            </div>

            <h3 style="margin-top: 2rem; margin-bottom: 1rem;">Player Attendance</h3>
            <div class="table-wrapper">
                <table class="styled-table">
                    <thead><tr><th>Player</th><th>Status</th></tr></thead>
                    <tbody>
                        <?php foreach ($team_players as $player): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></td>
                                <td>
                                    <select name="attendance[<?php echo $player->id; ?>]" required>
                                        <option value="Present" <?php echo (($attendance_map[$player->id] ?? '') === 'Present') ? 'selected' : ''; ?>>Present</option>
                                        <option value="Absent" <?php echo (($attendance_map[$player->id] ?? '') === 'Absent') ? 'selected' : ''; ?>>Absent</option>
                                        <option value="Excused" <?php echo (($attendance_map[$player->id] ?? '') === 'Excused') ? 'selected' : ''; ?>>Excused</option>
                                    </select>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <button type="submit" style="margin-top: 1.5rem;">Update Attendance</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>