<?php
require_once '../../core/bootstrap.php';

header('Content-Type: application/json');

$input = json_decode(file_get_contents('php://input'), true);
$campaign_id = $input['campaign_id'] ?? null;
$action = $input['action'] ?? null;

if ($campaign_id && $action) {
    $sponsorModel = new Sponsorship();
    
    if ($action === 'view') {
        $sponsorModel->incrementViews($campaign_id);
        echo json_encode(['status' => 'success']);
    } elseif ($action === 'click') {
        $sponsorModel->incrementClicks($campaign_id);
        
        // Fetch campaign details to return target
        $campaign = $sponsorModel->getCampaignById($campaign_id);
        echo json_encode([
            'status' => 'success',
            'target_url' => $campaign->target_url ?? null,
            'contact_number' => $campaign->contact_number ?? null
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid parameters']);
}
?>