<?php
require_once '../../core/bootstrap.php';

if (!isset($_SESSION['user_id']) || $_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(403);
    exit();
}

$id = filter_input(INPUT_POST, 'id', FILTER_VALIDATE_INT);
$user_id = $_SESSION['user_id'];

if ($id) {
    $notificationModel = new Notification();
    $notificationModel->markAsRead($id, $user_id);
    echo json_encode(['status' => 'success']);
} else {
    echo json_encode(['status' => 'error']);
}