<?php
header('Content-Type: application/json');
require_once '../../core/bootstrap.php';

$player_id = filter_input(INPUT_GET, 'player_id', FILTER_VALIDATE_INT);
$season = filter_input(INPUT_GET, 'season', FILTER_SANITIZE_STRING);
$team_id = filter_input(INPUT_GET, 'team_id', FILTER_VALIDATE_INT);

if (!$player_id) {
    http_response_code(400);
    echo json_encode(['error' => 'Player ID is required.']);
    exit();
}

$statModel = new Stat();

$stats = $statModel->getStatsForPlayer(
    $player_id,
    ($season === 'career' || !$season) ? null : $season,
    ($team_id === 'all' || !$team_id) ? null : $team_id
);

echo json_encode($stats);
?>