<?php
$pageTitle = 'Add Injury Record';
include 'includes/header.php';

// --- Authentication and Role Check ---
if (!isset($_SESSION['user_id']) || $_SESSION['user_role'] !== 'team_manager') {
    header('Location: login.php');
    exit();
}
$manager_id = $_SESSION['user_id'];

// --- Instantiate Models and Fetch Data ---
$teamModel = new Team();
$playerModel = new Player();

// Get the manager's team to find the players
$team = $teamModel->getTeamByManagerId($manager_id);

$team_players = [];
if ($team) {
    $team_players = $playerModel->getPlayersByTeamId($team->id);
} else {
    // If no team, they can't add an injury.
    header('Location: my_team.php');
    exit();
}

?>

<div class="page-content">
    <div class="matches-header">
        <h1>Report New Injury</h1>
        <a href="injury_list.php" class="btn btn-secondary"><i class="fa-solid fa-arrow-left"></i> Back to List</a>
    </div>

    <div class="dashboard-section form-card-wrapper">
        <form action="add_injury_process.php" method="POST" class="styled-form">
            <div class="form-group">
                <label for="player_id">Player</label>
                <select name="player_id" id="player_id" required>
                    <option value="">-- Select a Player --</option>
                    <?php foreach ($team_players as $player): ?>
                        <option value="<?php echo $player->id; ?>"><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="injury_description">Injury Description</label>
                <input type="text" id="injury_description" name="injury_description" placeholder="e.g., Hamstring Strain" required>
            </div>
            <div class="form-group">
                <label for="start_date">Date of Injury</label>
                <input type="date" id="start_date" name="start_date" required>
            </div>
            <div class="form-group">
                <label for="expected_return_date">Expected Return Date (Optional)</label>
                <input type="date" id="expected_return_date" name="expected_return_date">
            </div>

            <div class="form-actions">
                <button type="submit" class="btn btn-primary">Save Record</button>
            </div>
        </form>
    </div>
</div>

<style>
.form-card-wrapper {
    max-width: 600px;
    margin: 0 auto;
    background: #fff;
    padding: 2rem;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.05);
}
.styled-form .form-group {
    margin-bottom: 1.5rem;
}
.styled-form label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #2c3e50;
}
.styled-form input, .styled-form select {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 6px;
    font-size: 1rem;
}
.form-actions {
    margin-top: 2rem;
    text-align: right;
}
</style>

<?php include 'includes/footer.php'; ?>