<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Instantiate Stats model
$stats = new Stats();

// Get the league ID from the URL query string and validate it
$league_id = filter_input(INPUT_GET, 'league_id', FILTER_VALIDATE_INT);

if (!$league_id) {
    http_response_code(400); // Bad Request
    echo json_encode(['message' => 'A valid integer league_id is required.']);
    exit();
}

// Fetch the top scorers from the database
$topScorers = $stats->getTopScorers($league_id);

http_response_code(200); // OK
echo json_encode($topScorers);
?>