<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
require_once '../../../core/bootstrap.php';

$league_id = filter_input(INPUT_GET, 'league_id', FILTER_VALIDATE_INT);
$type = filter_input(INPUT_GET, 'type', FILTER_SANITIZE_STRING);

if (!$league_id || !$type) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid league_id and type are required.']);
    exit();
}

$statModel = new Stat();
$data = [];

switch ($type) {
    case 'goals':
        $data = $statModel->getTopScorers($league_id);
        break;
    case 'assists':
        $data = $statModel->getTopAssists($league_id);
        break;
    case 'clean_sheets':
        $data = $statModel->getMostCleanSheets($league_id);
        break;
    case 'cards':
        $data = $statModel->getMostCards($league_id);
        break;
    case 'fouls':
        $data = $statModel->getMostFouls($league_id);
        break;
    case 'team':
        $data = $statModel->getTeamStatsByLeague($league_id);
        break;
}

http_response_code(200);
echo json_encode($data);
?>