<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

require_once '../../../core/bootstrap.php';
require_once '../middleware/validate_token.php';

if ($authenticated_user_data->role !== 'team_manager') {
    http_response_code(403);
    echo json_encode(['message' => 'Forbidden: You are not a team manager.']);
    exit();
}

$teamModel = new Team();
$fixtureModel = new Fixture();

$team = $teamModel->getTeamByManagerId($authenticated_user_data->id);
if (!$team) {
    http_response_code(404);
    echo json_encode(['message' => 'You are not assigned to a team.']);
    exit();
}

$fixtures = $fixtureModel->getUpcomingFixturesForTeam($team->id);
http_response_code(200);
echo json_encode($fixtures);
?>