<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

require_once '../../../core/bootstrap.php';

$fixture_id = filter_input(INPUT_GET, 'fixture_id', FILTER_VALIDATE_INT);

if (!$fixture_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid fixture ID is required.']);
    exit();
}

$leagueModel = new League();

try {
    // The getLiveTable method will internally handle fetching the correct league
    // and calculating the live standings based on the provided fixture.
    $liveTable = $leagueModel->getLiveTable($fixture_id);
    http_response_code(200);
    echo json_encode($liveTable);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['message' => 'An error occurred while fetching the live league table.', 'error' => $e->getMessage()]);
}
?>