<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');
header('Access-Control-Allow-Headers: Access-Control-Allow-Headers,Content-Type,Access-Control-Allow-Methods, Authorization, X-Requested-With');

require_once '../../../core/bootstrap.php';

// Get user from token
$user = new User();
$user_id = $user->getUserIdFromToken();
if (!$user_id) {
    http_response_code(401);
    echo json_encode(['message' => 'Unauthorized']);
    exit();
}

$followModel = new Follow();

$followed_players = $followModel->getFollowedPlayers($user_id);
$followed_clubs = $followModel->getFollowedClubs($user_id);

http_response_code(200);
echo json_encode([
    'players' => $followed_players,
    'clubs' => $followed_clubs
]);
?>