<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
require_once '../../../core/bootstrap.php';

$fixture_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$fixture_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid integer fixture ID is required.']);
    exit();
}

$stats = new Stats();
$fixtureStats = $stats->getFixtureStats($fixture_id);

http_response_code(200);
echo json_encode($fixtureStats);
?>