<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: POST');
require_once '../../../core/bootstrap.php';
require_once '../middleware/validate_token.php';

$fantasyLeagueModel = new FantasyLeague();
$data = json_decode(file_get_contents("php://input"));

if (empty($data->name)) {
    http_response_code(400);
    echo json_encode(['message' => 'League name is required.']);
    exit();
}

try {
    $league_id = $fantasyLeagueModel->create($data->name, $authenticated_user_data->id);
    if ($league_id) {
        http_response_code(201);
        echo json_encode(['message' => 'League created successfully!', 'league_id' => $league_id]);
    } else {
        throw new Exception('Failed to create league.');
    }
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['message' => $e->getMessage()]);
}
?>