<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

require_once '../../../core/bootstrap.php';
require_once '../middleware/validate_token.php';

$fantasySquadModel = new FantasySquad();

$fantasy_team_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$fantasy_team_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid fantasy team ID is required.']);
    exit();
}

try {
    $squad = $fantasySquadModel->getSquadByTeamId($fantasy_team_id);
    if (empty($squad)) {
        http_response_code(404);
        echo json_encode(['message' => 'Squad not found for this team. Please select your squad.']);
        exit();
    }
    http_response_code(200);
    echo json_encode($squad);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['message' => 'An error occurred while fetching the squad.']);
}
?>