<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// This endpoint can be public or protected, depending on whether you want
// non-logged-in users to browse players. For now, let's make it public.
// require_once '../middleware/validate_token.php';

// Instantiate Player model
$player = new Player();

// Get all players with their details
$allPlayers = $player->getAllPlayersWithDetails(); // We'll add this method to Player model

if ($allPlayers) {
    http_response_code(200); // OK
    echo json_encode($allPlayers);
} else {
    http_response_code(404); // Not Found
    echo json_encode(['message' => 'No players found.']);
}
?>