<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
require_once '../../../core/bootstrap.php';

$league_id = filter_input(INPUT_GET, 'league_id', FILTER_VALIDATE_INT);

if (!$league_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid integer league_id is required.']);
    exit();
}

$fixtureModel = new Fixture();
$leagueModel = new League();

// Fetch all the data components for the dashboard
$live_matches = $fixtureModel->getLiveMatches($league_id);
$recent_results = $fixtureModel->getRecentResults($league_id, 3);
$upcoming_fixtures = $fixtureModel->getUpcomingFixtures($league_id, 3);

// Get the full table and take a snapshot of the top teams
$full_table = $leagueModel->getLeagueTable($league_id);
$table_snapshot = array_slice($full_table, 0, 5); // Get top 5 teams

http_response_code(200);
echo json_encode([
    'live_matches' => $live_matches,
    'recent_results' => $recent_results,
    'upcoming_fixtures' => $upcoming_fixtures,
    'table_snapshot' => $table_snapshot
]);
?>