<?php
// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application
require_once '../../../core/bootstrap.php';

// Protect this action
require_once '../middleware/validate_token.php';

// Only commissioners can access this
if ($authenticated_user_data->role !== 'commissioner') {
    http_response_code(403); // Forbidden
    echo json_encode(['message' => 'Access Denied. Only commissioners can access this resource.']);
    exit();
}

// Instantiate Fixture model
$fixture = new Fixture();

// Get all fixtures assigned to this commissioner
$fixtures = $fixture->getAllByCommissioner($authenticated_user_data->id);

http_response_code(200);
echo json_encode($fixtures);
?>