<?php
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
require_once '../../../core/bootstrap.php';

$club_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$club_id) {
    http_response_code(400);
    echo json_encode(['message' => 'A valid integer club ID is required.']);
    exit();
}

$clubModel = new Club();
$playerModel = new Player();
$fixtureModel = new Fixture();
$user = new User();
$current_user_id = $user->getUserIdFromToken();

$club_details = $clubModel->getClubDetails($club_id, $current_user_id);

if (!$club_details) {
    http_response_code(404);
    echo json_encode(['message' => 'Club not found.']);
    exit();
}

// Fetch related data
$squad = [];
if ($club_details->team_id) {
    $squad = $playerModel->getAllByTeam($club_details->team_id);
}
$matches = $fixtureModel->getMatchesByClub($club_id, 10);
$stats = $clubModel->getClubStats($club_id);

http_response_code(200);
echo json_encode([
    'details' => $club_details,
    'squad' => $squad,
    'matches' => $matches,
    'stats' => $stats
]);
?>