<?php
// This is a protected endpoint.

// Set headers for JSON response
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');
header('Access-Control-Allow-Methods: GET');

// Bootstrap the application (loads config, autoloader, etc.)
require_once '../../../core/bootstrap.php';

// Include the JWT validation middleware.
// This will check for a valid token and exit if it's not found or invalid.
// If the token is valid, it provides the $authenticated_user_data variable.
require_once '../middleware/validate_token.php';

// If the script reaches this point, the user is authenticated.
http_response_code(200);
echo json_encode($authenticated_user_data);
?>