<?php
// c:\xampp\htdocs\smart_football\admin\view_wallet_code.php
$pageTitle = 'View Wallet Model';
include_once 'includes/header.php';

// --- Admin Check ---
if (!in_array($_SESSION['admin_user_role'] ?? '', ['super_admin', 'admin'])) {
    header('Location: dashboard.php');
    exit();
}

// Attempt to find the Wallet model
$possible_paths = [
    '../core/Wallet.php',
    '../app/models/Wallet.php',
    '../models/Wallet.php'
];

$found_path = '';
foreach ($possible_paths as $path) {
    if (file_exists($path)) {
        $found_path = $path;
        break;
    }
}

include_once 'includes/sidebar.php';
?>

<h1>Wallet Model Source Code</h1>

<div class="dashboard-section">
    <?php if ($found_path): ?>
        <p><strong>File:</strong> <?php echo htmlspecialchars(realpath($found_path)); ?></p>
        <div style="background: #1e1e1e; color: #d4d4d4; padding: 15px; border-radius: 5px; overflow-x: auto; font-family: 'Consolas', monospace; font-size: 0.9rem;">
            <pre><?php echo htmlspecialchars(file_get_contents($found_path)); ?></pre>
        </div>
    <?php else: ?>
        <div class="message error">Could not locate Wallet.php in standard directories.</div>
    <?php endif; ?>
</div>

<?php include_once 'includes/footer.php'; ?>