<?php
$pageTitle = 'System Settings';
include_once 'includes/header.php';

// --- Admin Check ---
if (!in_array($_SESSION['admin_user_role'] ?? '', ['admin', 'super_admin'])) {
    header('Location: dashboard.php');
    exit();
}

$settingModel = new Setting();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Handle Logo Upload
    $app_logo_path = $_POST['app_logo_current'] ?? '';
    if (isset($_FILES['app_logo_file']) && $_FILES['app_logo_file']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = '../uploads/system/';
        if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);
        
        $file_ext = strtolower(pathinfo($_FILES['app_logo_file']['name'], PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp', 'svg'];
        
        if (in_array($file_ext, $allowed)) {
            $filename = 'logo_' . time() . '.' . $file_ext;
            $target = $upload_dir . $filename;
            if (move_uploaded_file($_FILES['app_logo_file']['tmp_name'], $target)) {
                $app_logo_path = $target;
            }
        }
    }

    $data = [
        'app_name' => trim($_POST['app_name']),
        'app_logo' => $app_logo_path,
        'system_currency' => $_POST['system_currency'],
        'primary_color' => $_POST['primary_color'],
        'secondary_color' => $_POST['secondary_color'],
        'full_time_duration' => (int)$_POST['full_time_duration'],
        'half_time_duration' => (int)$_POST['half_time_duration'],
        'break_duration' => (int)$_POST['break_duration'],
        'referee_fee' => (float)$_POST['referee_fee'],
        'board_referee_fee' => (float)$_POST['board_referee_fee'],
        'fine_yellow_card' => (float)$_POST['fine_yellow_card'],
        'fine_red_card' => (float)$_POST['fine_red_card'],
        'suspension_red_card' => (int)$_POST['suspension_red_card'],
        'suspension_lift_condition' => $_POST['suspension_lift_condition'],
        'site_commission_percent' => (float)$_POST['site_commission_percent'],
        'site_commission_fine' => (float)$_POST['site_commission_fine'],
        'site_commission_referee' => (float)$_POST['site_commission_referee'],
        'site_commission_registration' => (float)$_POST['site_commission_registration'],
        'board_commission_percent' => (float)$_POST['board_commission_percent'],
        'transfer_window_start' => $_POST['transfer_window_start'],
        'transfer_window_end' => $_POST['transfer_window_end'],
        'registration_period_open' => isset($_POST['registration_period_open']) ? '1' : '0',
        'flutterwave_public_key' => trim($_POST['flutterwave_public_key']),
        'flutterwave_secret_key' => trim($_POST['flutterwave_secret_key']),
        'flutterwave_encryption_key' => trim($_POST['flutterwave_encryption_key']),
    ];

    if ($settingModel->updateMultiple($data)) {
        $_SESSION['flash_message'] = 'Settings updated successfully.';
    } else {
        $_SESSION['flash_error'] = 'Failed to update settings.';
    }
    header('Location: settings.php');
    exit();
}

$settings = $settingModel->getAll();
// Defaults
$app_name = $settings['app_name'] ?? 'Smart Football';
$app_logo = $settings['app_logo'] ?? URL_ROOT . '/public/assets/images/logo.png';
$system_currency = $settings['system_currency'] ?? 'USD';
$primary_color = $settings['primary_color'] ?? '#3498db';
$secondary_color = $settings['secondary_color'] ?? '#2c3e50';
$full_time_duration = $settings['full_time_duration'] ?? 90;
$half_time_duration = $settings['half_time_duration'] ?? 15;
$break_duration = $settings['break_duration'] ?? 5;
$referee_fee = $settings['referee_fee'] ?? 50;
$board_referee_fee = $settings['board_referee_fee'] ?? 0;
$fine_yellow_card = $settings['fine_yellow_card'] ?? 5;
$fine_red_card = $settings['fine_red_card'] ?? 10;
$suspension_red_card = $settings['suspension_red_card'] ?? 1;
$suspension_lift_condition = $settings['suspension_lift_condition'] ?? 'pay_and_serve';
$site_commission_percent = $settings['site_commission_percent'] ?? 5;
$site_commission_fine = $settings['site_commission_fine'] ?? 5;
$site_commission_referee = $settings['site_commission_referee'] ?? 5;
$site_commission_registration = $settings['site_commission_registration'] ?? 5;
$board_commission_percent = $settings['board_commission_percent'] ?? 10;
$transfer_window_start = $settings['transfer_window_start'] ?? '';
$transfer_window_end = $settings['transfer_window_end'] ?? '';
$registration_period_open = !empty($settings['registration_period_open']);
$flutterwave_public_key = $settings['flutterwave_public_key'] ?? '';
$flutterwave_secret_key = $settings['flutterwave_secret_key'] ?? '';
$flutterwave_encryption_key = $settings['flutterwave_encryption_key'] ?? '';

include_once 'includes/sidebar.php';
?>

<h1>System Settings</h1>

<?php if (isset($_SESSION['flash_message'])): ?><div class="message success"><?php echo $_SESSION['flash_message']; unset($_SESSION['flash_message']); ?></div><?php endif; ?>

<div class="dashboard-section">
    <form action="settings.php" method="POST" class="styled-form" style="max-width: 800px;" enctype="multipart/form-data">
        
        <h3>General Settings</h3>
        <div class="form-group">
            <label for="app_name">Application Name</label>
            <input type="text" name="app_name" id="app_name" value="<?php echo htmlspecialchars($app_name); ?>" required>
        </div>
        <div class="form-group">
            <label for="app_logo_file">App Logo</label>
            <?php if (!empty($app_logo)): ?>
                <div style="margin-bottom: 10px;"><img src="<?php echo htmlspecialchars($app_logo); ?>" alt="Current Logo" style="height: 50px; background: #eee; padding: 5px; border-radius: 5px;"></div>
            <?php endif; ?>
            <input type="file" name="app_logo_file" id="app_logo_file" accept="image/*">
            <input type="hidden" name="app_logo_current" value="<?php echo htmlspecialchars($app_logo); ?>">
            <small>Upload a new logo to replace the current one.</small>
        </div>
        <div class="form-group">
            <label for="system_currency">Currency Code</label>
            <select name="system_currency" id="system_currency">
                <option value="USD" <?php echo $system_currency === 'USD' ? 'selected' : ''; ?>>USD ($)</option>
                <option value="EUR" <?php echo $system_currency === 'EUR' ? 'selected' : ''; ?>>EUR (€)</option>
                <option value="GBP" <?php echo $system_currency === 'GBP' ? 'selected' : ''; ?>>GBP (£)</option>
                <option value="ZMW" <?php echo $system_currency === 'ZMW' ? 'selected' : ''; ?>>ZMW (K)</option>
            </select>
        </div>

        <h3>Branding</h3>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="primary_color">Primary Color</label>
                <input type="color" name="primary_color" id="primary_color" value="<?php echo htmlspecialchars($primary_color); ?>" style="height: 40px;">
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="secondary_color">Secondary Color</label>
                <input type="color" name="secondary_color" id="secondary_color" value="<?php echo htmlspecialchars($secondary_color); ?>" style="height: 40px;">
            </div>
        </div>

        <h3>Match & Competition</h3>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="full_time_duration">Full Time Duration (mins)</label>
                <input type="number" name="full_time_duration" id="full_time_duration" value="<?php echo $full_time_duration; ?>" required>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="half_time_duration">Half Time Break (mins)</label>
                <input type="number" name="half_time_duration" id="half_time_duration" value="<?php echo $half_time_duration; ?>" required>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="break_duration">Other Breaks (mins)</label>
                <input type="number" name="break_duration" id="break_duration" value="<?php echo $break_duration; ?>" required>
            </div>
        </div>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="referee_fee">Team Referee Fee (Per Team)</label>
                <input type="number" name="referee_fee" id="referee_fee" value="<?php echo htmlspecialchars($referee_fee); ?>" step="0.01" min="0" required>
                <small>Paid by each team before match.</small>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="board_referee_fee">Board Referee Fee (Per Match)</label>
                <input type="number" name="board_referee_fee" id="board_referee_fee" value="<?php echo htmlspecialchars($board_referee_fee); ?>" step="0.01" min="0" required>
                <small>Paid by Board after match.</small>
            </div>
        </div>

        <h3>Disciplinary Rules</h3>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="fine_yellow_card">Yellow Card Fine</label>
                <input type="number" name="fine_yellow_card" id="fine_yellow_card" value="<?php echo $fine_yellow_card; ?>" min="0" step="0.01" required>
                <small>Automatic fine amount for a yellow card.</small>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="fine_red_card">Red Card Fine</label>
                <input type="number" name="fine_red_card" id="fine_red_card" value="<?php echo $fine_red_card; ?>" min="0" step="0.01" required>
                <small>Automatic fine amount for a red card.</small>
            </div>
        </div>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="suspension_red_card">Red Card Suspension (Matches)</label>
                <input type="number" name="suspension_red_card" id="suspension_red_card" value="<?php echo $suspension_red_card; ?>" min="1" required>
                <small>Number of matches banned for a direct red card.</small>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="suspension_lift_condition">Suspension Lift Condition</label>
                <select name="suspension_lift_condition" id="suspension_lift_condition">
                    <option value="pay_and_serve" <?php echo $suspension_lift_condition === 'pay_and_serve' ? 'selected' : ''; ?>>Pay Fine AND Serve Ban</option>
                    <option value="serve_only" <?php echo $suspension_lift_condition === 'serve_only' ? 'selected' : ''; ?>>Serve Ban Only</option>
                    <option value="pay_only" <?php echo $suspension_lift_condition === 'pay_only' ? 'selected' : ''; ?>>Pay Fine Only</option>
                </select>
            </div>
        </div>

        <h3>Commissions</h3>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="site_commission_percent">Site Commission (Memberships) %</label>
                <input type="number" name="site_commission_percent" id="site_commission_percent" value="<?php echo $site_commission_percent; ?>" min="0" max="100" step="0.1" required>
                <small>Deducted from Club Memberships.</small>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="board_commission_percent">Board Commission (Memberships) %</label>
                <input type="number" name="board_commission_percent" id="board_commission_percent" value="<?php echo $board_commission_percent; ?>" min="0" max="100" step="0.1" required>
                <small>Deducted from Club Memberships.</small>
            </div>
        </div>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="site_commission_fine">Site Commission (Fines) %</label>
                <input type="number" name="site_commission_fine" id="site_commission_fine" value="<?php echo $site_commission_fine; ?>" min="0" max="100" step="0.1" required>
                <small>Deducted from Fine Payments.</small>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="site_commission_referee">Site Commission (Referee Fees) %</label>
                <input type="number" name="site_commission_referee" id="site_commission_referee" value="<?php echo $site_commission_referee; ?>" min="0" max="100" step="0.1" required>
                <small>Deducted from Referee Fees.</small>
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="site_commission_registration">Site Commission (Reg. Fees) %</label>
                <input type="number" name="site_commission_registration" id="site_commission_registration" value="<?php echo $site_commission_registration; ?>" min="0" max="100" step="0.1" required>
                <small>Deducted from Club Registration Fees.</small>
            </div>
        </div>

        <h3>Transfers & Registration</h3>
        <div class="form-group">
            <label><input type="checkbox" name="registration_period_open" <?php echo $registration_period_open ? 'checked' : ''; ?>> Registration Period Open (Allow roster edits)</label>
        </div>
        <div class="form-row" style="display: flex; gap: 20px;">
            <div class="form-group" style="flex: 1;">
                <label for="transfer_window_start">Transfer Window Start</label>
                <input type="date" name="transfer_window_start" id="transfer_window_start" value="<?php echo $transfer_window_start; ?>">
            </div>
            <div class="form-group" style="flex: 1;">
                <label for="transfer_window_end">Transfer Window End</label>
                <input type="date" name="transfer_window_end" id="transfer_window_end" value="<?php echo $transfer_window_end; ?>">
            </div>
        </div>

        <h3>Payment Gateway (Flutterwave)</h3>
        <div class="form-group">
            <label for="flutterwave_public_key">Public Key</label>
            <input type="text" name="flutterwave_public_key" id="flutterwave_public_key" value="<?php echo htmlspecialchars($flutterwave_public_key); ?>">
        </div>
        <div class="form-group">
            <label for="flutterwave_secret_key">Secret Key</label>
            <input type="password" name="flutterwave_secret_key" id="flutterwave_secret_key" value="<?php echo htmlspecialchars($flutterwave_secret_key); ?>">
        </div>
        <div class="form-group">
            <label for="flutterwave_encryption_key">Encryption Key</label>
            <input type="password" name="flutterwave_encryption_key" id="flutterwave_encryption_key" value="<?php echo htmlspecialchars($flutterwave_encryption_key); ?>">
        </div>

        <button type="submit" class="btn">Save Settings</button>
    </form>
</div>

<?php include_once 'includes/footer.php'; ?>