<?php
$pageTitle = 'Fantasy Season Rollover';
include 'includes/header.php';

// --- Admin Authentication & Authorization ---
if (!in_array($_SESSION['admin_user_role'], ['super_admin'])) {
    // Restrict this highly destructive action to super_admin only.
    $_SESSION['flash_error'] = 'You do not have permission to perform a season rollover.';
    header('Location: fantasy_management.php');
    exit();
}

$seasonModel = new Season();
$fantasyModel = new Fantasy();

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $previous_season = $_POST['previous_season'] ?? '';
    $confirmation_text = $_POST['confirmation_text'] ?? '';

    if ($previous_season && $confirmation_text === 'RESET FANTASY DATA') {
        if ($fantasyModel->performSeasonRollover($previous_season)) {
            $message = "Season Rollover Complete! All fantasy data for season {$previous_season} has been archived and teams have been reset.";
        } else {
            $error = "The season rollover process failed. Please check the server logs.";
        }
    } else {
        $error = "Invalid season selected or confirmation text did not match. No action was taken.";
    }
}

$all_seasons = $seasonModel->getAll();

include 'includes/sidebar.php';
?>

<div class="page-content">
    <h1>Fantasy Season Rollover</h1>

    <div class="message error" style="border-color: #c0392b;">
        <strong>DANGER ZONE:</strong> This action is irreversible. It will reset all fantasy points and bank balances, and delete all squads, private leagues, and transfer history for the selected season. It is designed to be run once at the end of a season to prepare for the next one.
    </div>

    <?php if ($message): ?><div class="message success"><?php echo $message; ?></div><?php endif; ?>
    <?php if ($error): ?><div class="message error"><?php echo $error; ?></div><?php endif; ?>

    <div class="form-container">
        <form action="season_rollover.php" method="POST" onsubmit="return confirm('ARE YOU ABSOLUTELY SURE? This will permanently alter your fantasy database.');">
            <div class="form-group">
                <label for="previous_season">Select the Season to End/Archive</label>
                <select name="previous_season" id="previous_season" required>
                    <option value="">-- Select a Season --</option>
                    <?php foreach ($all_seasons as $season): ?><option value="<?php echo htmlspecialchars($season->name); ?>"><?php echo htmlspecialchars($season->name); ?></option><?php endforeach; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="confirmation_text">To confirm, type "RESET FANTASY DATA" in the box below.</label>
                <input type="text" name="confirmation_text" id="confirmation_text" required pattern="RESET FANTASY DATA">
            </div>
            <button type="submit" class="btn btn-danger">Perform Season Rollover</button>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>