<?php
require_once '../core/bootstrap.php';

// --- Auth Check ---
$allowed_roles = ['admin', 'super_admin', 'fixtures_manager', 'league_manager'];
if (!in_array($_SESSION['admin_user_role'] ?? '', $allowed_roles)) {
    header('Location: dashboard.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $fixture_id = filter_input(INPUT_POST, 'fixture_id', FILTER_VALIDATE_INT);
    
    if ($fixture_id) {
        $db = new Database();
        // Update status to postponed.
        // This marks the match as not active for the current gameweek processing
        // while preserving the record for rescheduling.
        $db->query("UPDATE fixtures SET status = 'postponed' WHERE id = :id");
        $db->bind(':id', $fixture_id);
        
        if ($db->execute()) {
            $_SESSION['flash_message'] = 'Match marked as postponed.';
        } else {
            $_SESSION['flash_error'] = 'Failed to postpone match.';
        }
    } else {
        $_SESSION['flash_error'] = 'Invalid fixture ID.';
    }
}

header('Location: manage_fixtures.php');
exit();