<?php
$pageTitle = 'Manage Gameweek Deadlines';
include 'includes/header.php';

// --- Admin Authentication & Authorization ---
if (!in_array($_SESSION['admin_user_role'], ['admin', 'super_admin'])) {
    header('Location: dashboard.php');
    exit();
}

$seasonModel = new Season();
$leagueModel = new League();
$gameweekModel = new Gameweek(); // Instantiate the new model

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $league_id = filter_input(INPUT_POST, 'league_id', FILTER_VALIDATE_INT);
    $season_name = $_POST['season_name'] ?? '';

    if ($league_id && $season_name) {
        if (isset($_POST['reset_deadlines'])) {
            if ($gameweekModel->resetDeadlines($league_id, $season_name)) {
                $message = "Deadlines for season {$season_name} have been reset.";
            } else {
                $error = "Failed to reset deadlines.";
            }
        } elseif ($gameweekModel->calculateAndSetAllDeadlines($league_id, $season_name)) {
            $message = "Deadlines for season {$season_name} calculated and set successfully!";
        } else {
            $error = "Could not calculate deadlines. Ensure fixtures with gameweek numbers exist for the selected season.";
        }
    } else {
        $error = "Please select a valid league and season.";
    }
}

$all_seasons = $seasonModel->getAll();
$all_leagues = $leagueModel->getAll();

include 'includes/sidebar.php';
?>

<div class="page-content">
    <h1>Manage Gameweek Deadlines</h1>
    <p>This tool will find the first match of each gameweek in a season and set the fantasy transfer deadline to 1 hour before kickoff.</p>

    <?php if ($message): ?><div class="message success"><?php echo $message; ?></div><?php endif; ?>
    <?php if ($error): ?><div class="message error"><?php echo $error; ?></div><?php endif; ?>

    <div class="form-container">
        <form action="manage_gameweeks.php" method="POST">
            <div class="form-group"><label for="league_id">League</label><select name="league_id" id="league_id" required><?php foreach ($all_leagues as $league): ?><option value="<?php echo $league->id; ?>"><?php echo htmlspecialchars($league->name); ?></option><?php endforeach; ?></select></div>
            <div class="form-group"><label for="season_name">Season</label><select name="season_name" id="season_name" required><?php foreach ($all_seasons as $season): ?><option value="<?php echo htmlspecialchars($season->name); ?>"><?php echo htmlspecialchars($season->name); ?></option><?php endforeach; ?></select></div>
            <div class="form-actions" style="display: flex; gap: 10px;">
                <button type="submit" name="calculate_deadlines" class="btn">Calculate & Set Deadlines</button>
                <button type="submit" name="reset_deadlines" class="btn btn-danger" onclick="return confirm('Are you sure you want to clear all deadlines for this season?');">Reset Deadlines</button>
            </div>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>