<?php
require_once '../core/bootstrap.php';

$db = new Database();
echo "<h1>Installing Referee Fee Features</h1>";

// 1. Add columns to fixtures table
try {
    $db->query("ALTER TABLE fixtures ADD COLUMN home_team_paid_referee TINYINT(1) NOT NULL DEFAULT 0");
    $db->execute();
    echo "Added 'home_team_paid_referee' column.<br>";
} catch (Exception $e) { echo "Column 'home_team_paid_referee' likely exists.<br>"; }

try {
    $db->query("ALTER TABLE fixtures ADD COLUMN away_team_paid_referee TINYINT(1) NOT NULL DEFAULT 0");
    $db->execute();
    echo "Added 'away_team_paid_referee' column.<br>";
} catch (Exception $e) { echo "Column 'away_team_paid_referee' likely exists.<br>"; }

// 2. Add Referee Fee Setting
try {
    // Check if setting exists
    $db->query("SELECT id FROM settings WHERE setting_key = 'referee_fee'");
    if (!$db->single()) {
        $db->query("INSERT INTO settings (setting_key, setting_value) VALUES ('referee_fee', '50')");
        $db->execute();
        echo "Added 'referee_fee' setting (Default: 50).<br>";
    } else {
        echo "Setting 'referee_fee' already exists.<br>";
    }
} catch (Exception $e) { echo "Error adding setting: " . $e->getMessage() . "<br>"; }

echo "<br><strong>Installation Complete.</strong>";
?>