<?php
require_once '../core/bootstrap.php';

// --- Authentication and Role Check ---
// Ensure only admins can access this
if (!isset($_SESSION['user_id']) || !in_array($_SESSION['user_role'], ['admin', 'super_admin', 'super_fantasy_manager'])) {
    header('Location: ../app/login.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $team_id = filter_input(INPUT_POST, 'team_id', FILTER_VALIDATE_INT);

    if ($team_id) {
        $fantasyModel = new Fantasy();
        if ($fantasyModel->delete($team_id)) {
            // Redirect back to the list with success message
            header('Location: fantasy_teams.php?status=deleted');
        } else {
            header('Location: fantasy_teams.php?error=delete_failed');
        }
    } else {
        header('Location: fantasy_teams.php?error=invalid_id');
    }
} else {
    header('Location: fantasy_teams.php');
}
exit();