<?php
require_once '../core/bootstrap.php';

// --- Admin Authentication & Authorization ---
if (!in_array($_SESSION['admin_user_role'] ?? '', ['admin', 'super_admin', 'super_fantasy_manager'])) {
    header('Location: dashboard.php');
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['prices'])) {
    header('Location: fantasy_players.php');
    exit();
}

$prices = $_POST['prices'];
$playerModel = new Player();
$success = true;

foreach ($prices as $player_id => $price) {
    // Sanitize and validate
    $player_id = (int)$player_id;
    $price = (float)$price;

    if ($player_id > 0 && $price > 0) {
        if (!$playerModel->updateFantasyPrice($player_id, $price)) {
            $success = false;
            // You could log the specific error here
        }
    }
}

header('Location: fantasy_players.php?status=' . ($success ? 'success' : 'error'));
exit();