<?php
$pageTitle = 'Manage Fantasy Players';
include 'includes/header.php';

// --- Admin Authentication & Authorization ---
// The main auth check is in header.php. This is a role-specific check.
if (!in_array($_SESSION['admin_user_role'], ['admin', 'super_admin', 'super_fantasy_manager'])) {
    header('Location: dashboard.php');
    exit();
}

// --- Instantiate Models ---
$playerModel = new Player();

// Assuming league_id 1 for now. This could be made dynamic.
try {
    $players = $playerModel->getPlayersForFantasySelection(1);
} catch (Exception $e) {
    $players = [];
    $error_message = "Error loading players: " . $e->getMessage();
}
?>

<?php include 'includes/sidebar.php'; ?>

<div class="page-content">
    <div class="matches-header">
        <h1>Manage Player Prices</h1>
    </div>

    <?php if (isset($error_message)): ?>
        <div class="status-message error"><?php echo htmlspecialchars($error_message); ?></div>
    <?php endif; ?>

    <!-- Display any success or error messages -->
    <?php if (isset($_GET['status'])): ?>
        <div class="status-message <?php echo $_GET['status'] === 'success' ? 'success' : 'error'; ?>">
            <?php
            if ($_GET['status'] === 'success') {
                echo 'Player prices updated successfully!';
            } else {
                echo 'An error occurred while updating prices.';
            }
            ?>
        </div>
    <?php endif; ?>

    <div class="dashboard-section">
        <form action="fantasy_players_process.php" method="POST">
            <div class="table-wrapper">
                <table class="styled-table">
                    <thead>
                        <tr>
                            <th>Player</th>
                            <th>Club</th>
                            <th>Position</th>
                            <th>Current Price ($m)</th>
                            <th>New Price ($m)</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($players as $player): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($player->first_name . ' ' . $player->last_name); ?></td>
                                <td><?php echo htmlspecialchars($player->club_name); ?></td>
                                <td><?php echo htmlspecialchars($player->position); ?></td>
                                <td><?php echo number_format($player->fantasy_price, 1); ?></td>
                                <td>
                                    <input type="number" name="prices[<?php echo $player->id; ?>]" value="<?php echo $player->fantasy_price; ?>" step="0.1" min="3.0" max="15.0" class="price-input">
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <div class="form-submit-bar">
                <button type="submit" class="btn">Update All Prices</button>
            </div>
        </form>
    </div>
</div>

<?php include 'includes/footer.php'; ?>