<?php
$pageTitle = 'Fantasy Management';
// Use the admin-specific header which has the correct authentication logic.
include 'includes/header.php';

// --- Admin Authentication & Authorization ---
// The authentication check is now handled by 'includes/header.php'.
// We can add a more specific role check here if needed.
if (!in_array($_SESSION['admin_user_role'], ['admin', 'super_admin', 'super_fantasy_manager'])) {
    // Redirect if user is not an admin or super_admin
    header('Location: dashboard.php'); // Or an access denied page
    exit();
}

include 'includes/sidebar.php';
?>

<div class="page-content">
    <div class="matches-header">
        <h1>Fantasy Management</h1>
    </div>

    <div class="admin-dashboard">
        <div class="admin-card">
            <h3>Manage Player Prices</h3>
            <p>Set and adjust fantasy prices for all players in the league.</p>
            <a href="fantasy_players.php" class="btn">Manage Players</a>
        </div>
        <div class="admin-card">
            <h3>View All Teams</h3>
            <p>View all user-created fantasy teams for the current season.</p>
            <a href="fantasy_teams.php" class="btn">View Fantasy Teams</a>
        </div>
        <div class="admin-card">
            <h3>Calculate Gameweek Points</h3>
            <p>Run the points calculation engine for a specific gameweek.</p>
            <a href="process_fantasy_points.php" class="btn">Process Points</a>
        </div>
        <div class="admin-card">
            <h3>View Points Log</h3>
            <p>Check the detailed breakdown of fantasy points for players.</p>
            <a href="fantasy_points_log.php" class="btn">View Log</a>
        </div>
        <div class="admin-card">
            <h3>Gameweek Stats</h3>
            <p>View top performing players for a specific gameweek.</p>
            <a href="fantasy_gameweek_stats.php" class="btn">View Stats</a>
        </div>
        <div class="admin-card">
            <h3>Manage Gameweeks</h3>
            <p>Calculate and set the transfer deadlines for all gameweeks in a season.</p>
            <a href="manage_gameweeks.php" class="btn">Manage Deadlines</a>
        </div>
        <div class="admin-card danger-zone">
            <h3>Season Rollover</h3>
            <p>Reset all fantasy data to prepare for a new season. This is irreversible.</p>
            <a href="season_rollover.php" class="btn btn-danger">Reset Season Data</a>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>