<?php
require_once '../core/bootstrap.php';

// Check if user is logged in and is an admin
if (!is_logged_in() || !is_admin()) {
    header('Location: ../login.php');
    exit;
}

$clubModel = new Club();
$club_id = $_GET['id'] ?? null;

if (!$club_id) {
    header('Location: manage_clubs.php');
    exit;
}

$club = $clubModel->findById($club_id);

if (!$club) {
    header('Location: manage_clubs.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Add a check for a confirmation field to prevent accidental deletion
    if (isset($_POST['confirm_delete'])) {
        // NOTE: In a real-world app, you should check for related records (teams, players)
        // before deleting to avoid orphaned data or foreign key constraint errors.
        if ($clubModel->delete($club_id)) {
            header('Location: manage_clubs.php?status=deleted');
            exit;
        } else {
            $error = "Failed to delete the club. It might be in use.";
        }
    }
}

$page_title = 'Delete Club';
include '../includes/admin_header.php';
?>

<div class="container">
    <h1>Delete Club: <?php echo htmlspecialchars($club->name); ?></h1>
    <p class="text-danger"><strong>Warning:</strong> Are you sure you want to delete this club? This action cannot be undone. Deleting a club may fail if it has teams or players associated with it.</p>
    
    <?php if (isset($error)): ?><div class="alert alert-danger"><?php echo $error; ?></div><?php endif; ?>

    <form action="delete_club.php?id=<?php echo $club->id; ?>" method="post">
        <input type="hidden" name="confirm_delete" value="1">
        <button type="submit" class="btn btn-danger">Yes, Delete This Club</button>
        <a href="manage_clubs.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>

<?php include '../includes/admin_footer.php'; ?>