<?php
$pageTitle = 'Add Announcement';
include_once 'includes/header.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = [
        'title' => trim($_POST['title']),
        'content' => trim($_POST['content']),
        'type' => $_POST['type'],
        'created_by' => $_SESSION['user_id']
    ];

    $announcementModel = new Announcement();
    if ($announcementModel->create($data)) {
        header('Location: manage_announcements.php?status=created');
        exit();
    }
}

include_once 'includes/sidebar.php';
?>

<h1>Post Announcement</h1>

<div class="form-container">
    <form action="add_announcement.php" method="POST">
        <div class="form-group">
            <label for="title">Title</label>
            <input type="text" name="title" id="title" required placeholder="e.g., Season Update">
        </div>
        <div class="form-group">
            <label for="type">Type</label>
            <select name="type" id="type">
                <option value="news">News</option>
                <option value="alert">Alert</option>
                <option value="info">Info</option>
            </select>
        </div>
        <div class="form-group">
            <label for="content">Content</label>
            <textarea name="content" id="content" rows="5" required placeholder="Enter announcement details..."></textarea>
        </div>
        <button type="submit" class="btn">Post Announcement</button>
    </form>
</div>

<?php include_once 'includes/footer.php'; ?>
