# Smart Football

A comprehensive football league management system with PWA capabilities, live scores, and fantasy league features.

## Installation

### 1. Upload Files
Upload all files to your web server. You can place them in the root directory (e.g., `public_html`) or a subdirectory (e.g., `public_html/smart_football`).

### 2. Create Database
Create a new MySQL database and a user with full permissions on that database via your hosting control panel (cPanel, Plesk, etc.).

### 3. Run Setup
Navigate to your website URL in a browser (e.g., `https://yourdomain.com` or `https://yourdomain.com/smart_football`).

The system will automatically detect that it is not installed and redirect you to the **Setup Wizard**.

### 4. Configure
Follow the on-screen instructions:
- Enter your **Database Credentials** (Host, Name, User, Password).
- Verify the **Site Root URL**. The script attempts to auto-detect this.
  - *Note:* If you installed in a subfolder (e.g., `/smart_football`) but want it accessible via the main domain, you must point your domain's "Document Root" to that folder in your hosting settings.
- Create your **Super Admin** account.

### 5. Finalize
Once installation is complete, the system will generate a `core/config.php` file and a `.htaccess` file tailored to your installation path.

**Security Warning:** After successful installation, delete the `setup.php` file from your server.

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or MariaDB 10.2+
- Apache Web Server (with `mod_rewrite` enabled)
- SSL Certificate (HTTPS) is recommended for PWA features.

## Support
For issues regarding installation, please check the `error_log` file on your server.